/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.object;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RescaleOp;
import jpcsp.format.RCO;
import jpcsp.format.rco.IDisplay;
import jpcsp.format.rco.ObjectField;
import jpcsp.format.rco.anim.AbstractAnimAction;
import jpcsp.format.rco.object.BaseObject;
import jpcsp.format.rco.object.ImageObject;
import jpcsp.format.rco.type.EventType;
import jpcsp.format.rco.type.FloatType;
import jpcsp.format.rco.type.IntType;
import jpcsp.format.rco.vsmx.interpreter.VSMXArray;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;

public class BasePositionObject
extends BaseObject
implements IDisplay {
    @ObjectField(order=101)
    public FloatType posX;
    @ObjectField(order=102)
    public FloatType posY;
    @ObjectField(order=103)
    public FloatType posZ;
    @ObjectField(order=104)
    public FloatType redScale;
    @ObjectField(order=105)
    public FloatType greenScale;
    @ObjectField(order=106)
    public FloatType blueScale;
    @ObjectField(order=107)
    public FloatType alphaScale;
    @ObjectField(order=108)
    public FloatType width;
    @ObjectField(order=109)
    public FloatType height;
    @ObjectField(order=110)
    public FloatType depth;
    @ObjectField(order=111)
    public FloatType scaleWidth;
    @ObjectField(order=112)
    public FloatType scaleHeight;
    @ObjectField(order=113)
    public FloatType scaleDepth;
    @ObjectField(order=114)
    public IntType iconOffset;
    @ObjectField(order=115)
    public EventType onInit;
    public float rotateX;
    public float rotateY;
    public float rotateAngle;
    public float animX;
    public float animY;
    public float animZ;

    @Override
    public int getWidth() {
        BufferedImage image;
        float w = this.width.getFloatValue();
        if (w == 0.0f && (image = this.getImage()) != null) {
            w = image.getWidth();
        }
        return Math.round(w * this.scaleWidth.getFloatValue());
    }

    @Override
    public int getHeight() {
        BufferedImage image;
        float h = this.height.getFloatValue();
        if (h == 0.0f && (image = this.getImage()) != null) {
            h = image.getHeight();
        }
        return Math.round(h * this.scaleHeight.getFloatValue());
    }

    @Override
    public BufferedImage getImage() {
        BaseNativeObject texture;
        VSMXBaseObject textureObject;
        BufferedImage image = null;
        if (this.getObject().hasPropertyValue("texture") && (textureObject = this.getObject().getPropertyValue("texture")) instanceof VSMXNativeObject && (texture = ((VSMXNativeObject)textureObject).getObject()) instanceof ImageObject) {
            image = ((ImageObject)texture).getImage();
        }
        return image;
    }

    @Override
    public int getX() {
        int parentX = 0;
        if (this.getParent() instanceof BasePositionObject) {
            parentX = ((BasePositionObject)this.getParent()).getX();
        }
        return parentX + this.posX.getIntValue() + Math.round(this.animX);
    }

    @Override
    public int getY() {
        int parentY = 0;
        if (this.getParent() instanceof BasePositionObject) {
            parentY = ((BasePositionObject)this.getParent()).getY();
        }
        return parentY + this.posY.getIntValue() + Math.round(this.animY);
    }

    @Override
    public float getAlpha() {
        return this.alphaScale.getFloatValue();
    }

    @Override
    public BufferedImage getAnimImage() {
        BufferedImage image = this.getImage();
        if (image == null) {
            return image;
        }
        if (!(image.getColorModel() instanceof IndexColorModel)) {
            float[] scales = new float[]{this.redScale.getFloatValue(), this.greenScale.getFloatValue(), this.blueScale.getFloatValue(), this.alphaScale.getFloatValue()};
            float[] offsets = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            RescaleOp colorRescale = new RescaleOp(scales, offsets, null);
            image = colorRescale.filter(image, null);
        }
        if (this.rotateAngle != 0.0f) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Rotating image at (%f,%f) by %f", Float.valueOf(this.rotateX), Float.valueOf(this.rotateY), Float.valueOf(this.rotateAngle)));
            }
            AffineTransform rotation = new AffineTransform();
            rotation.rotate(-this.rotateAngle, this.rotateX + (float)(image.getWidth() / 2), this.rotateY + (float)(image.getHeight() / 2));
            AffineTransformOp op = new AffineTransformOp(rotation, 2);
            image = op.filter(image, null);
        }
        return image;
    }

    public void setPos(VSMXBaseObject object, VSMXBaseObject posX, VSMXBaseObject posY) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setPos(%s, %s)", posX, posY));
        }
        this.posX.setFloatValue(posX.getFloatValue());
        this.posY.setFloatValue(posY.getFloatValue());
    }

    public void setPos(VSMXBaseObject object, VSMXBaseObject posX, VSMXBaseObject posY, VSMXBaseObject posZ) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setPos(%s, %s, %s)", posX, posY, posZ));
        }
        this.posX.setFloatValue(posX.getFloatValue());
        this.posY.setFloatValue(posY.getFloatValue());
        this.posZ.setFloatValue(posZ.getFloatValue());
    }

    public VSMXBaseObject getPos(VSMXBaseObject object) {
        VSMXInterpreter interpreter = object.getInterpreter();
        VSMXArray pos = new VSMXArray(interpreter, 3);
        pos.setPropertyValue(0, (VSMXBaseObject)new VSMXNumber(interpreter, this.posX.getFloatValue()));
        pos.setPropertyValue(1, (VSMXBaseObject)new VSMXNumber(interpreter, this.posY.getFloatValue()));
        pos.setPropertyValue(2, (VSMXBaseObject)new VSMXNumber(interpreter, this.posZ.getFloatValue()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("getPos() returning %s", pos));
        }
        return pos;
    }

    public void setRotate(VSMXBaseObject object, VSMXBaseObject x, VSMXBaseObject y, VSMXBaseObject rotationRads) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setRotate(%s, %s, %s)", x, y, rotationRads));
        }
        this.rotateX = x.getFloatValue();
        this.rotateY = y.getFloatValue();
        this.rotateAngle = rotationRads.getFloatValue();
    }

    public VSMXBaseObject getColor(VSMXBaseObject object) {
        VSMXInterpreter interpreter = object.getInterpreter();
        VSMXArray color = new VSMXArray(interpreter, 4);
        color.setPropertyValue(0, (VSMXBaseObject)new VSMXNumber(interpreter, this.redScale.getFloatValue()));
        color.setPropertyValue(1, (VSMXBaseObject)new VSMXNumber(interpreter, this.greenScale.getFloatValue()));
        color.setPropertyValue(2, (VSMXBaseObject)new VSMXNumber(interpreter, this.blueScale.getFloatValue()));
        color.setPropertyValue(3, (VSMXBaseObject)new VSMXNumber(interpreter, this.alphaScale.getFloatValue()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("getColor() returning %s", color));
        }
        return color;
    }

    public void setColor(VSMXBaseObject object, VSMXBaseObject red, VSMXBaseObject green, VSMXBaseObject blue, VSMXBaseObject alpha) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setColor(%s, %s, %s, %s)", red, green, blue, alpha));
        }
        this.redScale.setFloatValue(red.getFloatValue());
        this.greenScale.setFloatValue(green.getFloatValue());
        this.blueScale.setFloatValue(blue.getFloatValue());
        this.alphaScale.setFloatValue(alpha.getFloatValue());
        this.onDisplayUpdated();
    }

    public void animColor(VSMXBaseObject object, VSMXBaseObject red, VSMXBaseObject green, VSMXBaseObject blue, VSMXBaseObject alpha, VSMXBaseObject duration) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("animColor(%s, %s, %s, %s, %s)", red, green, blue, alpha, duration));
        }
        AnimColorAction action = new AnimColorAction(red.getFloatValue(), green.getFloatValue(), blue.getFloatValue(), alpha.getFloatValue(), duration.getIntValue());
        BasePositionObject.getScheduler().addAction(action);
    }

    public void setScale(VSMXBaseObject object, VSMXBaseObject width, VSMXBaseObject height, VSMXBaseObject depth) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setScale(%s, %s, %s)", width, height, depth));
        }
        this.onDisplayUpdated();
    }

    public void animScale(VSMXBaseObject object, VSMXBaseObject width, VSMXBaseObject height, VSMXBaseObject depth, VSMXBaseObject duration) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("animScale(%s, %s, %s, %s)", width, height, depth, duration));
        }
        AnimScaleAction action = new AnimScaleAction(width.getFloatValue(), height.getFloatValue(), depth.getFloatValue(), duration.getIntValue());
        BasePositionObject.getScheduler().addAction(action);
    }

    public void animPos(VSMXBaseObject object, VSMXBaseObject x, VSMXBaseObject y, VSMXBaseObject z, VSMXBaseObject duration) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("animPos from (%s,%s,%s) to (%s, %s, %s), duration=%s", this.posX, this.posY, this.posZ, x, y, z, duration));
        }
        AnimPosAction action = new AnimPosAction(x.getFloatValue(), y.getFloatValue(), z.getFloatValue(), duration.getIntValue());
        BasePositionObject.getScheduler().addAction(action);
    }

    public void animRotate(VSMXBaseObject object, VSMXBaseObject x, VSMXBaseObject y, VSMXBaseObject rotationRads, VSMXBaseObject duration) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("animRotate(%s, %s, %s, %s)", x, y, rotationRads, duration));
        }
        AnimRotateAction action = new AnimRotateAction(x.getFloatValue(), y.getFloatValue(), rotationRads.getFloatValue(), duration.getIntValue());
        BasePositionObject.getScheduler().addAction(action);
    }

    public void setFocus() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setFocus()", new Object[0]));
        }
        if (this.display != null) {
            this.display.setFocus(this.getObject());
        }
        if (this.controller != null) {
            this.controller.setFocus(this);
        }
    }

    public void setFocus(VSMXBaseObject object) {
        this.setFocus();
    }

    public void focusOut() {
    }

    public void setSize(VSMXBaseObject object, VSMXBaseObject width, VSMXBaseObject height, VSMXBaseObject depth) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("setSize(%s, %s, %s)", width, height, depth));
        }
        this.width.setFloatValue(width.getFloatValue());
        this.height.setFloatValue(height.getFloatValue());
        this.depth.setFloatValue(depth.getFloatValue());
        this.onDisplayUpdated();
    }

    public void onUp() {
    }

    public void onDown() {
    }

    public void onLeft() {
    }

    public void onRight() {
    }

    public void onPush() {
    }

    @Override
    public VSMXBaseObject createVSMXObject(VSMXInterpreter interpreter, VSMXBaseObject parent, RCO.RCOEntry entry) {
        VSMXBaseObject object = super.createVSMXObject(interpreter, parent, entry);
        BufferedImage image = this.getImage();
        if (image != null) {
            object.setPropertyValue("texture", (VSMXBaseObject)new VSMXNativeObject(interpreter, new ImageObject(image)));
        }
        return object;
    }

    private class AnimColorAction
    extends AbstractAnimAction {
        private float red;
        private float green;
        private float blue;
        private float alpha;
        private float startRed;
        private float startGreen;
        private float startBlue;
        private float startAlpha;

        public AnimColorAction(float red, float green, float blue, float alpha, int duration) {
            super(duration);
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.startRed = BasePositionObject.this.redScale.getFloatValue();
            this.startGreen = BasePositionObject.this.greenScale.getFloatValue();
            this.startBlue = BasePositionObject.this.blueScale.getFloatValue();
            this.startAlpha = BasePositionObject.this.alphaScale.getFloatValue();
        }

        @Override
        protected void anim(float step) {
            BasePositionObject.this.redScale.setFloatValue(AnimColorAction.interpolate(this.startRed, this.red, step));
            BasePositionObject.this.greenScale.setFloatValue(AnimColorAction.interpolate(this.startGreen, this.green, step));
            BasePositionObject.this.blueScale.setFloatValue(AnimColorAction.interpolate(this.startBlue, this.blue, step));
            BasePositionObject.this.alphaScale.setFloatValue(AnimColorAction.interpolate(this.startAlpha, this.alpha, step));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("AnimColorAction scaling from (%f,%f,%f,%f) to (%f,%f,%f,%f)", Float.valueOf(this.startRed), Float.valueOf(this.startGreen), Float.valueOf(this.startBlue), Float.valueOf(this.startAlpha), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha)));
            }
            BasePositionObject.this.onDisplayUpdated();
        }
    }

    private class AnimScaleAction
    extends AbstractAnimAction {
        private float width;
        private float height;
        private float depth;
        private float startWidth;
        private float startHeight;
        private float startDepth;

        public AnimScaleAction(float width, float height, float depth, int duration) {
            super(duration);
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.startWidth = BasePositionObject.this.scaleWidth.getFloatValue();
            this.startHeight = BasePositionObject.this.scaleHeight.getFloatValue();
            this.startDepth = BasePositionObject.this.scaleDepth.getFloatValue();
        }

        @Override
        protected void anim(float step) {
            BasePositionObject.this.scaleWidth.setFloatValue(AnimScaleAction.interpolate(this.startWidth, this.width, step));
            BasePositionObject.this.scaleHeight.setFloatValue(AnimScaleAction.interpolate(this.startHeight, this.height, step));
            BasePositionObject.this.scaleDepth.setFloatValue(AnimScaleAction.interpolate(this.startDepth, this.depth, step));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("AnimScaleAction scaling from (%f,%f,%f) to (%f,%f,%f)", Float.valueOf(this.startWidth), Float.valueOf(this.startHeight), Float.valueOf(this.startDepth), Float.valueOf(BasePositionObject.this.scaleWidth.getFloatValue()), Float.valueOf(BasePositionObject.this.scaleHeight.getFloatValue()), Float.valueOf(BasePositionObject.this.scaleDepth.getFloatValue())));
            }
            BasePositionObject.this.onDisplayUpdated();
        }
    }

    private class AnimPosAction
    extends AbstractAnimAction {
        private float x;
        private float y;
        private float z;
        private float startX;
        private float startY;
        private float startZ;

        public AnimPosAction(float x, float y, float z, int duration) {
            super(duration);
            this.x = x;
            this.y = y;
            this.z = z;
            this.startX = BasePositionObject.this.posX.getFloatValue();
            this.startY = BasePositionObject.this.posY.getFloatValue();
            this.startZ = BasePositionObject.this.posZ.getFloatValue();
        }

        @Override
        protected void anim(float step) {
            BasePositionObject.this.posX.setFloatValue(AnimPosAction.interpolate(this.startX, this.x, step));
            BasePositionObject.this.posY.setFloatValue(AnimPosAction.interpolate(this.startY, this.y, step));
            BasePositionObject.this.posZ.setFloatValue(AnimPosAction.interpolate(this.startZ, this.z, step));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("AnimPosAction from (%f,%f,%f) to (%f,%f,%f)", Float.valueOf(this.startX), Float.valueOf(this.startY), Float.valueOf(this.startZ), Float.valueOf(BasePositionObject.this.posX.getFloatValue()), Float.valueOf(BasePositionObject.this.posY.getFloatValue()), Float.valueOf(BasePositionObject.this.posZ.getFloatValue())));
            }
            BasePositionObject.this.onDisplayUpdated();
        }
    }

    private class AnimRotateAction
    extends AbstractAnimAction {
        private float angle;

        public AnimRotateAction(float x, float y, float angle, int duration) {
            super(duration);
            BasePositionObject.this.rotateX = x;
            BasePositionObject.this.rotateY = y;
            this.angle = angle;
        }

        @Override
        protected void anim(float step) {
            BasePositionObject.this.rotateAngle = this.angle * step;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("AnimRotateAction to angle=%f", Float.valueOf(BasePositionObject.this.rotateAngle)));
            }
            BasePositionObject.this.onDisplayUpdated();
        }
    }
}

